import 'dart:convert';
import 'package:flutter/cupertino.dart';
import 'package:get/get.dart';
import 'package:viserpay_agent/core/helper/string_format_helper.dart';
import 'package:viserpay_agent/core/route/route.dart';
import 'package:viserpay_agent/core/utils/my_strings.dart';
import 'package:viserpay_agent/data/model/general_setting/general_setting_response_model.dart';
import 'package:viserpay_agent/data/model/global/response_model/response_model.dart';
import 'package:viserpay_agent/data/model/home/home_response_model.dart';
import 'package:viserpay_agent/data/repo/home/home_repo.dart';
import 'package:viserpay_agent/data/repo/menu_repo/menu_repo.dart';
import 'package:viserpay_agent/view/components/snack_bar/show_custom_snackbar.dart';

class HomeController extends GetxController {
  HomeRepo homeRepo;
  MenuRepo menuRepo;
  HomeController({required this.homeRepo, required this.menuRepo});

  bool isLoading = true;

  String username = "";
  String balance = "";
  String email = "";
  String mobile = "";
  String fullName = "";

  String totalMoneyOut = "";
  String defaultCurrency = "";
  String defaultCurrencySymbol = "";
  String siteName = "";
  String totalMoneyReceived = "";

  String totalAddMoney = "";
  String totalWithdraw = "";
  String imagePath = "";

  bool isKycVerified = true;
  bool isKycPending = false;

  HomeResponseModel model = HomeResponseModel();
  GeneralSettingResponseModel generalSettingResponseModel = GeneralSettingResponseModel();
  List<LatestTrx> trxList = [];

  bool isWithdrawModuleEnable = true;
  bool isAddMoneyModuleEnable = true;

  List<Widget> bottomSheetModuleList = [];

  Future<void> initialData({bool isRefresh = false}) async {
    bottomSheetModuleList = homeRepo.apiClient.getBottomSheetModuleList();
    isWithdrawModuleEnable = homeRepo.apiClient.getModuleStatus("withdraw_money");
    isAddMoneyModuleEnable = homeRepo.apiClient.getModuleStatus("add_money");
    isLoading = isRefresh ? false : true;
    update();

    await loadData();
    isLoading = false;
    update();

    await homeRepo.refreshGeneralSetting();
    await homeRepo.refreshModuleSetting();

    bottomSheetModuleList = homeRepo.apiClient.getBottomSheetModuleList();
    isWithdrawModuleEnable = homeRepo.apiClient.getModuleStatus("withdraw_money");
    isAddMoneyModuleEnable = homeRepo.apiClient.getModuleStatus("add_money");
    update();
  }

  Future<void> loadData() async {
    defaultCurrency = homeRepo.apiClient.getCurrencyOrUsername();
    defaultCurrencySymbol = homeRepo.apiClient.getCurrencyOrUsername(isSymbol: true);
    generalSettingResponseModel = homeRepo.apiClient.getGSData();
    siteName = generalSettingResponseModel.data?.generalSetting?.siteName ?? "";

    ResponseModel responseModel = await homeRepo.getData();
    trxList.clear();

    if (responseModel.statusCode == 200) {
      HomeResponseModel model = HomeResponseModel.fromJson(jsonDecode(responseModel.responseJson));

      if (model.status.toString().toLowerCase() == MyStrings.success.toLowerCase()) {
        balance = model.data?.agent?.balance ?? "0";
        username = model.data?.agent?.username ?? "";
        email = model.data?.agent?.email ?? "";
        mobile = model.data?.agent?.mobile ?? "";
        fullName = "${model.data?.agent?.firstname} ${model.data?.agent?.lastname}";

        totalMoneyReceived = Converter.formatNumber(model.data?.last7DaycashInOut?.totalMoneyIn ?? "");
        totalMoneyOut = Converter.formatNumber(model.data?.last7DaycashInOut?.totalMoneyOut ?? "");

        totalAddMoney = model.data?.totalAddMoney ?? "";
        totalWithdraw = model.data?.totalWithdraw ?? "";

        imagePath = model.data?.agent?.getImage ?? '';
        isKycVerified = model.data?.agent?.kv == '1';
        isKycPending = model.data?.agent?.kv == '2';

        List<LatestTrx>? tempTrxList = model.data?.latestTrx;
        if (tempTrxList != null && tempTrxList.isNotEmpty) {
          trxList.addAll(tempTrxList);
        }
      } else {
        homeRepo.apiClient.sharedPreferences.clear();
        Get.offAndToNamed(RouteHelper.loginScreen);
        CustomSnackBar.error(errorList: model.message?.error ?? [MyStrings.somethingWentWrong]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message]);
    }
  }

  RxBool isAnimation = false.obs;
  RxBool isBalanceShown = false.obs;
  RxBool isBalance = true.obs;
  RxBool isClickable = true.obs;

  void changeState() async {
    if (!isClickable.value) {
      return;
    }

    isClickable.value = false;
    isAnimation.value = true;
    isBalance.value = false;

    await Future.delayed(const Duration(milliseconds: 500));
    isBalanceShown.value = true;

    await Future.delayed(const Duration(seconds: 3));
    isAnimation.value = false;
    isBalanceShown.value = false;

    await Future.delayed(const Duration(milliseconds: 500));
    isBalance.value = true;

    isClickable.value = true;
  }
}
